


local _l_rainV2_scale_LUT = {
--   Planner    rainFX v2
    {0.00, 		0.000 } ,
    {0.01, 		0.001 } ,
    {0.02, 		0.002 } ,
    {0.03, 		0.003 } ,
    {0.04, 		0.004 } ,
    {0.05, 		0.005 } ,
    {0.06, 		0.006 } ,
    {0.07, 		0.007 } ,
    {0.08, 		0.008 } ,
    {0.09, 		0.009 } ,
    {0.10, 		0.010 } ,
    {0.15, 		0.015 } ,
    {0.20, 		0.025 } ,
    {0.30, 		0.050 } ,
    {0.40, 		0.080 } ,
    {0.50, 		0.100 } ,
    {0.60, 		0.125 } ,
    {0.70, 		0.150 } ,
    {0.80, 		0.200 } ,
    {0.90, 		0.400 } ,
    {1.00, 		1.000 } ,
}
local _l_rainV2_scale__LUT
local _l_rainV2_scaleCPP = LUT:new(_l_rainV2_scale_LUT, nil)

function __PURE_WEATHER__scale_V2Rain(x)
    return _l_rainV2_scaleCPP:get(x)[1]
end


local _l_rainV2_unscale_LUT = {
--   rainFX v2  Planner
    {0.000,     0.00 } ,
    {0.001,     0.01 } ,
    {0.002,     0.02 } ,
    {0.003,     0.03 } ,
    {0.004,     0.04 } ,
    {0.005,     0.05 } ,
    {0.006,     0.06 } ,
    {0.007,     0.07 } ,
    {0.008,     0.08 } ,
    {0.009,     0.09 } ,
    {0.010,     0.10 } ,
    {0.015,     0.15 } ,
    {0.025,     0.20 } ,
    {0.050,     0.30 } ,
    {0.080,     0.40 } ,
    {0.100,     0.50 } ,
    {0.125,     0.60 } ,
    {0.150,     0.70 } ,
    {0.200,     0.80 } ,
    {0.400,     0.90 } ,
    {1.000,     1.00 } ,
    }
local _l_rainV2_unscale__LUT
local _l_rainV2_unscaleCPP = LUT:new(_l_rainV2_unscale_LUT, nil)

function __PURE_WEATHER__unscale_V2Rain(x)
    return _l_rainV2_unscaleCPP:get(x)[1]
end


local function setDefaultRaymarchData()

    return {
        high = {
            height      = 7000.0,
            thickness   = 300.0,
            scale       = 0.1,
            offset1     = 0.4,
            offset2     = 0.1,
            xOffset     = 0.25,
            yOffset     = -0.1,
            freq        = 0.3,
            water       = 0.0,
            cover       = 0.0,
            shape       = 0.2,
        },
        low = {
            height      = 1000.0,
            thickness   = 500.0,
            scale       = 1.0,
            offset1     = 0.0,
            offset2     = -0.5,
            xOffset     = 0.0,
            yOffset     = 0.0,
            freq        = 1.0,
            water       = 1.0,
            cover       = 2.0,
            shape       = 1.5,
        },
    }
end

local _l_bOverride_weather = false



local _l_config_weather_editor_data = {

    control = {
        override    = { id=100, value=false, reset=false, type=TYPES.BOOLEAN },
    },

    weather = {
        id          = { id=1001, value=0, min=0, max=500, reset=false, type=TYPES.INTEGER },
        name        = { id=1002, value="", min="", max="", reset=false, type=TYPES.STRING },
        material    = { id=1010, value=0, min=0, max=3, reset=false, type=TYPES.INTEGER },
        material_strength = { id=1011, value=0.0, min=0.0, max=1.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        humidity    = { id=1012, value=0.0, min=0.0, max=1.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        mist        = { id=1013, value=0.0, min=0.0, max=1.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        overcast    = { id=1014, value=0.0, min=0.0, max=1.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        badness     = { id=1015, value=0.0, min=0.0, max=1.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },

    raymarch = {
        high = {
            height      = { id=5001, value=7000.0, min=500.0, max=10000.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            thickness   = { id=5002, value=300.0, min=10.0, max=2000.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            scale       = { id=5003, value=0.1, min=0.1, max=2.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            offset1     = { id=5004, value=0.4, min=-1.0, max=1.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            offset2     = { id=5005, value=0.1, min=-1.0, max=1.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            xOffset     = { id=5006, value=0.25, min=-1.0, max=1.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            yOffset     = { id=5007, value=-0.1, min=-1.0, max=1.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            freq        = { id=5008, value=0.3, min=0.1, max=2.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            water       = { id=5009, value=0.0, min=0.0, max=5.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            cover       = { id=5010, value=0.0, min=0.0, max=5.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            shape       = { id=5011, value=0.2, min=0.0, max=2.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        },
        low = {
            height      = { id=5101, value=1000.0, min=500.0, max=10000.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            thickness   = { id=5102, value=500.0, min=10.0, max=2000.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            scale       = { id=5103, value=1.0, min=0.1, max=2.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            offset1     = { id=5104, value=0.0, min=-1.0, max=1.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            offset2     = { id=5105, value=-0.5, min=-1.0, max=1.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            xOffset     = { id=5106, value=0.0, min=-1.0, max=1.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            yOffset     = { id=5107, value=0.0, min=-1.0, max=1.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            freq        = { id=5108, value=1.0, min=0.1, max=2.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            water       = { id=5109, value=1.0, min=0.0, max=5.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            cover       = { id=5110, value=2.0, min=0.0, max=5.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            shape       = { id=5111, value=1.5, min=0.0, max=2.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        },
    },
}

-- config class to control the weather parameters in Pure Planner
local _l_ConfigWeatherEditor_init = false
local _l_ConfigWeatherEditor = ConfigTable:new(_l_config_weather_editor_data, true, "PurePlannerWeatherEditor", __PURE_version)
_l_ConfigWeatherEditor:initialize()


local function WE__get(key)
    return _l_ConfigWeatherEditor:getEntry(key)
end

local function WE__set(key, value, bRelative)
    return _l_ConfigWeatherEditor:setEntry(key, value, bRelative, CONFIG_ACCESS_MODE.FROM_SCRIPT)
end

local function WE__reset(key, value)
    return _l_ConfigWeatherEditor:setEntry(key, value, false, CONFIG_ACCESS_MODE.RESET_TO_DEFAULTS)
end



local function WE__set_data(CM_ID)
    if CM_ID then
        local weather_obj = __PURE__Weather_List:get(CM_ID)
        if weather_obj then
            WE__reset("weather.id", weather_obj.data.CM_ID)

            WE__reset("weather.name", "!todo!")
            WE__reset("weather.overcast", weather_obj.data.overcast)
            WE__reset("weather.badness", weather_obj.data.badness)
            WE__reset("weather.humidity", weather_obj.data.humidity)
            WE__reset("weather.mist", weather_obj.data.mist)
            WE__reset("weather.material", weather_obj.data.material.type)
            WE__reset("weather.material_strength", weather_obj.data.material.amount)

            --WE__reset("billboard.", weather_obj.data.cloud_params.)

            if weather_obj.data.cloud_raymarching_params then
                WE__reset("raymarch.high.height",       weather_obj.data.cloud_raymarching_params.high.height)
                WE__reset("raymarch.high.thickness",    weather_obj.data.cloud_raymarching_params.high.thickness)
                WE__reset("raymarch.high.scale",        weather_obj.data.cloud_raymarching_params.high.scale)
                WE__reset("raymarch.high.offset1",      weather_obj.data.cloud_raymarching_params.high.offset1)
                WE__reset("raymarch.high.offset2",      weather_obj.data.cloud_raymarching_params.high.offset2)
                WE__reset("raymarch.high.xOffset",      weather_obj.data.cloud_raymarching_params.high.xOffset)
                WE__reset("raymarch.high.yOffset",      weather_obj.data.cloud_raymarching_params.high.yOffset)
                WE__reset("raymarch.high.freq",         weather_obj.data.cloud_raymarching_params.high.freq)
                WE__reset("raymarch.high.water",        weather_obj.data.cloud_raymarching_params.high.water)
                WE__reset("raymarch.high.cover",        weather_obj.data.cloud_raymarching_params.high.cover)
                WE__reset("raymarch.high.shape",        weather_obj.data.cloud_raymarching_params.high.shape)

                WE__reset("raymarch.low.height",        weather_obj.data.cloud_raymarching_params.low.height)
                WE__reset("raymarch.low.thickness",     weather_obj.data.cloud_raymarching_params.low.thickness)
                WE__reset("raymarch.low.scale",         weather_obj.data.cloud_raymarching_params.low.scale)
                WE__reset("raymarch.low.offset1",       weather_obj.data.cloud_raymarching_params.low.offset1)
                WE__reset("raymarch.low.offset2",       weather_obj.data.cloud_raymarching_params.low.offset2)
                WE__reset("raymarch.low.xOffset",       weather_obj.data.cloud_raymarching_params.low.xOffset)
                WE__reset("raymarch.low.yOffset",       weather_obj.data.cloud_raymarching_params.low.yOffset)
                WE__reset("raymarch.low.freq",          weather_obj.data.cloud_raymarching_params.low.freq)
                WE__reset("raymarch.low.water",         weather_obj.data.cloud_raymarching_params.low.water)
                WE__reset("raymarch.low.cover",         weather_obj.data.cloud_raymarching_params.low.cover)
                WE__reset("raymarch.low.shape",         weather_obj.data.cloud_raymarching_params.low.shape)
            end
        end
    end
end

local function WE__fill_raymarch_data(buffer)
    if buffer then
        buffer.high.height      = WE__get("raymarch.high.height")
        buffer.high.thickness   = WE__get("raymarch.high.thickness")
        buffer.high.scale       = WE__get("raymarch.high.scale")
        buffer.high.offset1     = WE__get("raymarch.high.offset1")
        buffer.high.offset2     = WE__get("raymarch.high.offset2")
        buffer.high.xOffset     = WE__get("raymarch.high.xOffset")
        buffer.high.yOffset     = WE__get("raymarch.high.yOffset")
        buffer.high.freq        = WE__get("raymarch.high.freq")
        buffer.high.water       = WE__get("raymarch.high.water")
        buffer.high.cover       = WE__get("raymarch.high.cover")
        buffer.high.shape       = WE__get("raymarch.high.shape")

        buffer.low.height       = WE__get("raymarch.low.height")
        buffer.low.thickness    = WE__get("raymarch.low.thickness")
        buffer.low.scale        = WE__get("raymarch.low.scale")
        buffer.low.offset1      = WE__get("raymarch.low.offset1")
        buffer.low.offset2      = WE__get("raymarch.low.offset2")
        buffer.low.xOffset      = WE__get("raymarch.low.xOffset")
        buffer.low.yOffset      = WE__get("raymarch.low.yOffset")
        buffer.low.freq         = WE__get("raymarch.low.freq")
        buffer.low.water        = WE__get("raymarch.low.water")
        buffer.low.cover        = WE__get("raymarch.low.cover")
        buffer.low.shape        = WE__get("raymarch.low.shape")
    end  
end


function handleCommand_FromPurePlanner_WeatherEditor(cmd, value)

    if cmd == "loadWeather" then
        if value then
            WE__set_data(tonumber(value))
        end
    elseif cmd == "loadPast" then
        if value and __PURE__Weather_List and __PURE__Weather_List.past then
            WE__set_data(__PURE__Weather_List.past.data.CM_ID)
        end
    elseif cmd == "loadNext" then
        if value and __PURE__Weather_List and __PURE__Weather_List.next then
            WE__set_data(__PURE__Weather_List.next.data.CM_ID)
        end
    end
end



















Weather = {}
function Weather:new(CM_ID)
  local o = {}
  setmetatable(o, self)
  self.__index = self

  o.backup = {
    CM_ID = CM_ID,
    overcast = 0.00,
    cloud_coverage = 0.00,
    badness = 0.00,
    lightnings = 0.00,
    humidity = 0.00,
    mist = 0.00,
    material = { type = __PURE__weather_materials.none, amount = 0.0 },
    snow_amount = 0.0,
    snow_size = 0.0,
    snow_rain_mix = 0.0,
    ash_amount = 0.0,
    ash_size = 0.0,
    cloud_params = nil, -- data for 3d billboard clouds
    cloud_raymarching_params = nil, -- data for raymarching clouds
  }

  o.data = {
    CM_ID = CM_ID,
    overcast = 0.00,
    cloud_coverage = 0.00,
    badness = 0.00,
    lightnings = 0.00,
    humidity = 0.00,
    mist = 0.00,
    material = { type = __PURE__weather_materials.none, amount = 0.0 },
    snow_amount = 0.0,
    snow_size = 0.0,
    snow_rain_mix = 0.0,
    ash_amount = 0.0,
    ash_size = 0.0,
    cloud_params = nil, -- data for 3d billboard clouds
    cloud_raymarching_params = nil, -- data for raymarching clouds
  }

  if __PURE__Clouds__method == 2 then
    o.backup.cloud_raymarching_params = setDefaultRaymarchData()
    o.data.cloud_raymarching_params   = setDefaultRaymarchData()
  end
--[[
  o.CM_ID = CM_ID
  o.overcast = 0.00
  o.badness = 0.00
  o.humidity = 0.00
  o.mist = 0.00
  o.material = { type = __PURE__weather_materials.none, amount = 0.0 }
  o.cloud_params = nil -- data for 3d billboard clouds
  o.cloud_raymarching_params = nil -- data for raymarching clouds
]]
  return o
end

function Weather:setOvercast(x)
    self.data.overcast = math.saturate(x)
end
function Weather:setCloudCoverage(x)
    self.data.cloud_coverage = math.saturate(x or 0)
end
function Weather:setHumidity(x)
    self.data.humidity = math.saturate(x)
end
function Weather:setMist(x)
    self.data.mist = math.saturate(x)
end
function Weather:setBadness(x)
    self.data.badness = math.saturate(x)
end
function Weather:setLightnings(x)
    self.data.lightnings = math.saturate(x)
end
function Weather:setSnow(v, s, m)
    self.data.snow_intensity = math.saturate(v or 0)
    self.data.snow_size = math.saturate(s or 0)
    self.data.snow_rain_mix = math.saturate(m or 0)
end
function Weather:setAsh(v, s)
    self.data.ash_amount = math.saturate(v or 0)
    self.data.ash_size = math.saturate(s or 0)
end
function Weather:setMaterial(type, x)
    self.data.material.type   = type
    self.data.material.amount = math.saturate(x)
end
function Weather:setClouds(params)
    self.data.cloud_params = params
end
function Weather:hasCloudLayer(layer)
    if self.data.cloud_params and self.data.cloud_params[layer] then
        return true
    end
    return false
end
-- setting 3d billboard data
function Weather:setCloudLayer(layer, params)
    if self.data.cloud_params and self.data.cloud_params[layer] then
        self.data.cloud_params[layer] = params
    end
end
-- setting raymarching data
function Weather:setCloudData(layer, params)
    if self.data.cloud_raymarching_params and self.data.cloud_raymarching_params[layer] then
        self.data.cloud_raymarching_params[layer] = params
    end
end

WeatherList = {}
function WeatherList:new()
    local o = {}
    setmetatable(o, self)
    self.__index = self

    o.list = {}
    o.n_list = 0

    o.past = nil
    o.next = nil
    o.current = Weather:new(-1)

    o.transition = 0

    -- create a list of all cloud types, to count the clouds
    o.layerCloudsList = {}
    
    if __PURE__Clouds__method < 2 then
        for k, v in pairs(__PURE__cloud_types) do
            o.layerCloudsList[k] = {}
        end
    else

    end

    return o
end

function WeatherList:get(CM_ID)

    if CM_ID then
        for i=1, self.n_list do
            if CM_ID == self.list[i].data.CM_ID then
                return self.list[i]
            end
        end
    end

    return nil
end


function WeatherList:importDefinitions(filename)

    if file_exists(filename) then
        --[[
		local f=io.open(filename,"r")
		if f==nil then return nil end

        local data = json.decode(f)
        if data then
            
        end
        ]]
    else

    end
end

function WeatherList:exportDefinitions(filename)


end


function WeatherList:addWeather(CM_ID)
    self.n_list = self.n_list + 1
    self.list[self.n_list] = Weather:new(CM_ID)
    return self.list[self.n_list]
end


function WeatherList:getPast()
    return self.past
end
function WeatherList:getNext()
    return self.next
end
function WeatherList:getTransistion()
    return self.transition
end

function WeatherList:setPast(CM_ID)
    self.past = self:get(CM_ID) or self.past
end
function WeatherList:setNext(CM_ID)
    self.next = self:get(CM_ID) or self.next
end
function WeatherList:addNext(CM_ID)
    self.past = self.next or self.past
    self.next = self:get(CM_ID) or self.next
end

function WeatherList:getPastCloudLayerParameter(layer_type, param)
    if self.past and self.past.data.cloud_params and self.past.data.cloud_params[layer_type] then
        if self.past.data.cloud_params[layer_type][param] then
            return self.past.data.cloud_params[layer_type][param]
        end
    end

    return 0
end
function WeatherList:getNextCloudLayerParameter(layer_type, param)
    if self.next and self.next.data.cloud_params and self.next.data.cloud_params[layer_type] then
        if self.next.data.cloud_params[layer_type][param] then
            return self.next.data.cloud_params[layer_type][param]
        end
    end

    return 0
end


-- setting 3d billboard clouds parameters
local _l_additional_cloud_params = {"water_min", "water_max"}
local a
local b
function WeatherList:setClouds(transition, fadePosition)

    self.transition = transition

    if __PURE__Clouds__method == 1 and clouds__2D__setClouds~=nil then

        clouds__2D__setClouds(__PURE__condition_get("currentType"),
                              __PURE__condition_get("upcomingType"),
                              transition,
                              fadePosition
        )
    end

    if __PURE__Clouds__method < 1 then

        for k, v in pairs(__PURE__cloud_types) do

            a = self:getPastCloudLayerParameter(k, "dense")
            b = self:getNextCloudLayerParameter(k, "dense")
            self.layerCloudsList[k]["count"] = math.floor(
                                                math.lerp(a, b, transition)
                                                * v.count
                                            )
             ac.debug("C | "..k, self.layerCloudsList[k]["count"])

            for i=1, #_l_additional_cloud_params do
                a = self:getPastCloudLayerParameter(k, _l_additional_cloud_params[i])
                b = self:getNextCloudLayerParameter(k, _l_additional_cloud_params[i])
                self.layerCloudsList[k][_l_additional_cloud_params[i]] = math.lerp(a, b, transition)
            end                                 
        end 

        clouds__3D__setClouds(self.layerCloudsList)
    elseif __PURE__Clouds__method < 2 then

        a = self:getPastCloudLayerParameter("shadows", "dense")
        b = self:getNextCloudLayerParameter("shadows", "dense")
        self.layerCloudsList["shadows"]["count"] = math.floor(
                                            math.lerp(a, b, transition)
                                            * __PURE__cloud_types.shadows.count
                                        )
            --ac.debug("C | shadows", self.layerCloudsList["shadows"]["count"])

        for i=1, #_l_additional_cloud_params do
            a = self:getPastCloudLayerParameter("shadows", _l_additional_cloud_params[i])
            b = self:getNextCloudLayerParameter("shadows", _l_additional_cloud_params[i])
            self.layerCloudsList["shadows"][_l_additional_cloud_params[i]] = math.lerp(a, b, transition)
        end                                 
        
        clouds__3D__setClouds(self.layerCloudsList)
    else

        --clouds__3D_RAYMARCHING__setClouds()
    end

end

function WeatherList:getCloudsCount(type)
    if __PURE__Clouds__method < 2 then
        return self.layerCloudsList[type]["count"]
    else
        --clouds__3D_RAYMARCHING__setClouds()
    end
end

function WeatherList:getRainAmount()

    local tmp = __PURE__condition_get("rainIntensity")
    if __CSP_version >= 2253 then
		-- RainFX v2
        local version = __PURE__condition_get("variableC")
        if version >= 2.3 then
            tmp = math.pow(math.saturate(_l_rainV2_unscaleCPP:get(tmp)[1]), 0.5)
        end
	end

    return tmp
end


local _l_tempMaterial = { type = __PURE__weather_materials.none, amount = 0.0 }
local _l_tempRaymarchA = setDefaultRaymarchData()
local _l_tempRaymarchB = setDefaultRaymarchData()
function WeatherList:calcCurrent(transition)

    if _l_bOverride_weather then
        
        self.current:setOvercast(WE__get("weather.overcast"))
        self.current:setCloudCoverage(WE__get("weather.cloud_coverage"))
        self.current:setBadness(WE__get("weather.badness"))
        self.current:setLightnings(WE__get("weather.lightnings"))
        self.current:setHumidity(WE__get("weather.humidity"))
        self.current:setMist(WE__get("weather.mist"))
        self.current:setSnow(WE__get("weather.snow_amount"), WE__get("weather.snow_size"), WE__get("weather.snow_rain_mix"))
        self.current:setAsh(WE__get("weather.ash_amount"), WE__get("weather.ash_size"))

        _l_tempMaterial.type    = WE__get("weather.material")
        _l_tempMaterial.amount  = WE__get("weather.material_strength")
        __PURE__fog_set_weather_material(_l_tempMaterial, _l_tempMaterial)
--[[
        if __PURE___RaymarchingClouds_setData then
            WE__fill_raymarch_data(_l_tempRaymarchA)
            __PURE___RaymarchingClouds_setData(_l_tempRaymarchA, self.current.data.overcast, _l_tempRaymarchA, self.current.data.overcast)
        end
]]
    else
        if self.past and self.next then

            self.current:setCloudCoverage(math.lerp(self.past.data.cloud_coverage, self.next.data.cloud_coverage, transition))
            self.current:setOvercast(math.lerp(self.past.data.overcast, self.next.data.overcast, transition))
            self.current:setBadness(math.lerp(self.past.data.badness, self.next.data.badness, transition))

            self.current:setSnow(math.lerp(self.past.data.snow_amount,      self.next.data.snow_amount, transition),
                                 math.lerp(self.past.data.snow_size,        self.next.data.snow_size, transition),
                                 math.lerp(self.past.data.snow_rain_mix,    self.next.data.snow_rain_mix, transition))

            self.current:setAsh(math.lerp(self.past.data.ash_amount,      self.next.data.ash_amount, transition),
                                math.lerp(self.past.data.ash_size,        self.next.data.ash_size, transition))

            local lightning_exponent = 1.00
            if __PURE__Weather_List.past~=nil and __PURE__Weather_List.next~=nil then
                if __PURE__Weather_List.past.data.lightnings > __PURE__Weather_List.next.data.lightnings then
                    lightning_exponent = 0.25
                else
                    lightning_exponent = 4
                end
            end
            self.current:setLightnings(math.lerp(self.past.data.lightnings, self.next.data.lightnings, transition^lightning_exponent))

            self.current:setHumidity(math.lerp(self.past.data.humidity, self.next.data.humidity, transition))
            self.current:setMist(math.lerp(self.past.data.mist, self.next.data.mist, transition))
    
            __PURE__fog_set_weather_material(self.past.data.material, self.next.data.material)
        elseif self.past then
            self.current = table__deepcopy(self.past)
            __PURE__fog_set_weather_material(self.past.data.material, self.past.data.material)
        elseif self.next then
            self.current = table__deepcopy(self.next)
            __PURE__fog_set_weather_material(self.next.data.material, self.next.data.material)
        end
    end
    
end


-- main weather list object
__PURE__Weather_List = WeatherList:new()
__PURE__Weather_List:addWeather(100) -- NoClouds



-- add the weather definitions file
dofile (__pure__path.."\\weather\\weather_definitions.lua")

-- update the weather's advanced cloud shadows if 2d clouds are used
if __PURE__Clouds__method == 1 then
    if __PURE_use_3d_cloud_shadows then
        local list = PURE__2DCLOUDS_get_weather_cloud_shadows_list()
        if list then
            for k,v in pairs(list) do
                local weather_obj = __PURE__Weather_List:get(k)
                if weather_obj then
                    weather_obj:setCloudLayer("shadows", {dense = v})
                end
            end
        end
    end
end







-- State connection from Pure Planner app, to receive the data from Pure Planner app
__PURE_CTRL__STATE = PureState:new(nil, true, "PurePlanner_Controller")



local _l_next_fast_change = 0


local function PURE_WEATHER__set_condition()

    local use_controller_condition = true

    if __PURE_CTRL__STATE:isConnected() then

        if __PURE_CTRL__STATE:getValue('time.fastchange') then
            -- catch a fast time change state and react / give it some time
            _l_next_fast_change = os.clock() + 4
            __PURE_CTRL__STATE:setValue('time.fastchange', false)
        else
            if math.abs(os.clock() - _l_next_fast_change) < 1 then
                if PURE__2DCLOUDS_doInstantFade then
                    PURE__2DCLOUDS_doInstantFade()
                    --ac.debug("call instant fade", os.clock())
                    _l_next_fast_change = 0
                end
            end
        end
        
        if __PURE_CTRL__STATE:getValue('pure.direct') then
            
            local cond = __PURE__condition_get_struct()
            if cond then

                if  __AC_SIM.raceSessionType ~= ac.SessionType.Qualify and
                    __AC_SIM.raceSessionType ~= ac.SessionType.Race then

                    cond.variableC 		    = __PURE_CTRL__STATE:getValue("ctrl.version") or 0
                
                    cond.currentType 		= __PURE_CTRL__STATE:getValue("weather.current") 	or 100
                    cond.upcomingType 	    = __PURE_CTRL__STATE:getValue("weather.next") 		or 100
                    cond.transition 		= __PURE_CTRL__STATE:getValue("weather.transition") 	or 0.0

                    cond.humidity 		    = __PURE_CTRL__STATE:getValue("weather.humidity")	or 0.4
                    cond.variableA 		    = __PURE_CTRL__STATE:getValue("weather.mist")		or 0.0
                    
                    cond.rainIntensity	    = __PURE_CTRL__STATE:getValue("weather.rain.intensity") 	or 0.0
                    cond.rainWetness		= __PURE_CTRL__STATE:getValue("weather.rain.wetness") 	or 0.0
                    cond.rainWater		    = __PURE_CTRL__STATE:getValue("weather.rain.water") 		or 0.0

                    cond.wind.direction	    = __PURE_CTRL__STATE:getValue("weather.wind.direction") 	or 0.0
                    cond.wind.speedFrom	    = __PURE_CTRL__STATE:getValue("weather.wind.strength") 	or 0.0
                    cond.wind.speedTo		= cond.wind.speedFrom + cond.wind.speedFrom * 0.25
                    
                    cond.temperatures.road 	    = __PURE_CTRL__STATE:getValue("weather.temp.road") 	or 10.0
                    cond.temperatures.ambient   = __PURE_CTRL__STATE:getValue("weather.temp.ambient") 	or 20.0
                
                    use_controller_condition = false
                end
            end
        end
    end

    if use_controller_condition then
        __PURE__condition_set(ac.getConditionsSet())
    end
end





local _l_controller_version = 0


local _l_world_fog_instance = __PURE__world__fog_get()
local _l_last_past = -1
local _l_last_next = -1
local _l_transition = 0
local _l_checking_transition = 0
local _l_last_transition = 0
local _l_transition_jump = 0
local snow_amount = 0
local snow_size = 0
local snow_rain_mix = 0
local ash_amount = 0
local ash_size = 0

function __PURE__update_condition(dt)

--local time = os.preciseClock()
--ac.debug("###", (os.preciseClock()-time) * 1000000)   


    -- check the connection to Pure Planner App
    __PURE_CTRL__STATE:checkInterface()



    ------------------------------------------------------------------------------------
	-- Pure Planner / weather editor integration
	------------------------------------------------------------------------------------
    if not _l_ConfigWeatherEditor_init then
        _l_ConfigWeatherEditor:setCommandHandler(handleCommand_FromPurePlanner_WeatherEditor)
        _l_ConfigWeatherEditor_init = true
    else
        _l_ConfigWeatherEditor:update(dt)
        _l_bOverride_weather = WE__get("control.override")
    end
    
    ------------------------------------------------------------------------------------
	-- controller integration
	------------------------------------------------------------------------------------
    
	PURE_WEATHER__set_condition()
    
    
	_l_controller_version = __PURE__condition_get_struct().variableC or 2.1
	_l_controller_version = math.round(_l_controller_version*10)*0.1

    _l_checking_transition = __PURE__condition_get_struct().transition
    if math.abs(_l_checking_transition - _l_last_transition) > 1 then
        _l_checking_transition = _l_last_transition
    elseif math.abs(_l_checking_transition - _l_last_transition) > 0.9 then
        _l_transition = _l_checking_transition
    end
    _l_transition = math.saturate(_l_transition*(1-10*dt) + _l_checking_transition*10*dt)

    __PURE__condition_get_struct().transition = _l_transition

 
    __PURE__Weather_List:setPast(__PURE__condition_get("currentType"))
    __PURE__Weather_List:setNext(__PURE__condition_get("upcomingType"))

    -- if badness is falling, make fade (skydome texture fade) much earlier.
    local fadePosition = 0.75
    if __PURE__Weather_List.current.data.badness < __PURE__badness then
        fadePosition = 0.25
    end

    __PURE__Weather_List:setClouds(_l_transition, fadePosition)

    _l_transition_jump = math.abs(_l_transition - _l_last_transition)
    if  _l_last_past ~= __PURE__condition_get("currentType") and
        _l_transition_jump < 0.9 or
        _l_transition_jump > 0.1 then
        
        if __PURE__Clouds__method < 2 then
            clouds__3D__accelerateTransition()
        end
    end 

    
    --if __PURE__get_config("debug.weather") then
    --    ac.debug("W | Weather", string.format('Curr: %i, Next: %i, trans: %.3f', __PURE__condition_get("currentType"), __PURE__condition_get("upcomingType"), __PURE__condition_get("transition")))
    --end
    
    __PURE__STATE:setValue("weather.current", __PURE__condition_get("currentType"))
    __PURE__STATE:setValue("weather.next", __PURE__condition_get("upcomingType"))
    __PURE__STATE:setValue("weather.transition", _l_transition)
    

    __PURE__Weather_List:calcCurrent(_l_transition)

    if _l_bOverride_weather then
        __PURE__fog_set_humidity(__PURE__Weather_List.current.data.humidity, dt)
        __PURE__fog_set_mist(__PURE__Weather_List.current.data.mist, dt)
    else
        -- Just use it as the humidity value delivered from the meteorological services
        if _l_controller_version >= 2.1 then
            __PURE__fog_set_humidity(__PURE__condition_get("humidity"), dt) 
            __PURE__fog_set_mist(__PURE__condition_get("variableA"), dt)
        else
            -- set the humidity and fog from the weather definitions
            __PURE__fog_set_humidity(__PURE__Weather_List.current.data.humidity, dt)
            __PURE__fog_set_mist(__PURE__Weather_List.current.data.mist, dt)
        end
    end

    local tmp_dt = (1-dt)

    __PURE__cloud_coverage = __PURE__cloud_coverage*tmp_dt + __PURE__Weather_List.current.data.cloud_coverage*dt
    
    __PURE__overcast = __PURE__overcast*tmp_dt + __PURE__Weather_List.current.data.overcast*dt
    if __PURE__Clouds__method == 2 then
        __PURE__overcast = __PURE__overcast *0.5
    end

    _l_last_past        = __PURE__condition_get("currentType")
    --_l_last_next        = __PURE__condition_get("upcomingType")
    _l_last_transition  = _l_transition


    __PURE__badness     = __PURE__badness*tmp_dt + __PURE__Weather_List.current.data.badness*dt
    __PURE__lightnings  = __PURE__lightnings*tmp_dt + __PURE__Weather_List.current.data.lightnings*dt

    __PURE__rainFX.intensity = __PURE__rainFX.intensity*tmp_dt  + __PURE__condition_get("rainIntensity")*dt
    __PURE__rainFX.wetness   = __PURE__rainFX.wetness*tmp_dt    + __PURE__condition_get("rainWetness")*dt
    __PURE__rainFX.water     = __PURE__rainFX.water*tmp_dt      + __PURE__condition_get("rainWater")*dt

    __PURE__STATE:setValue("rain.intensity", __PURE__rainFX.intensity)
    __PURE__STATE:setValue("rain.wetness", __PURE__rainFX.wetness)
    __PURE__STATE:setValue("rain.water", __PURE__rainFX.water)

    local _l_temps = __PURE__condition_get("temperatures")
    if _l_temps then
        __PURE__Temperature.ambient = __PURE__Temperature.ambient*tmp_dt + _l_temps.ambient*dt
        __PURE__Temperature.road    = __PURE__Temperature.road*tmp_dt + _l_temps.road*dt
    end




    if ac.setWeatherParticles~=nil then

        if __PURE__get_config("weather.use_weather_particles")~=false then
            local conf_snow_size = __PURE__get_config("weather.snow.size")
            local conf_ash_size = __PURE__get_config("weather.ash.size")

            snow_amount = __PURE__Weather_List.current.data.snow_intensity or 0
            snow_size = __PURE__Weather_List.current.data.snow_size or 0
            snow_rain_mix = __PURE__Weather_List.current.data.snow_rain_mix or 0
            ash_amount = __PURE__Weather_List.current.data.ash_amount or 0
            ash_size = __PURE__Weather_List.current.data.ash_size or 0
            local rain = __PURE__rainFX.intensity or 0
        
            local temperature = __PURE__Temperature.ambient
        
            snow_amount   = math.lerp(math.max(rain, snow_amount), snow_amount, math.saturateN(temperature * 0.34))
            snow_size     = math.lerp(math.max(rain*0.25, snow_size), snow_size, math.saturateN(temperature * 0.34)) * conf_snow_size
            snow_rain_mix = math.max(snow_rain_mix, 1 - math.saturateN(temperature * 0.34)) * math.saturateN(conf_snow_size*10-1)
            
            snow_amount = snow_amount * (1 - math.saturateN(__PURE_CTRL__STATE:getValue("weather.wind.strength") * 0.015)^0.5)
            local damp = math.saturateN(snow_amount*1000-1) * math.saturateN(conf_snow_size*2-1)
            snow_amount = snow_amount * damp

            ash_size = ash_size * conf_ash_size
            damp = math.saturateN(ash_amount*5000-1) * math.saturateN(conf_ash_size*10-1)
            ash_amount = ash_amount * damp
        
            ac.setSnowMix(snow_rain_mix, snow_size)
            ac.setWeatherParticles('snow', snow_amount, snow_size)
            ac.setWeatherParticles('ash', ash_amount, ash_size)
        
            ac.setRainWindscreenDropsMultiplier(1 - 0.9*snow_amount*snow_rain_mix)

            __PURE__rainFX.intensity = __PURE__rainFX.intensity * (1 - snow_rain_mix)

            ac.setTrackConditionInput('SNOW', snow_amount)
            ac.setTrackConditionInput('ASH', ash_amount)
        else
            ac.setSnowMix(0, 0)
            ac.setWeatherParticles('snow', 0, 0)
            ac.setWeatherParticles('ash', 0, 0)

            ac.setRainWindscreenDropsMultiplier(1)
        end
    end
end